--[[

    GLuaHacks (c) 2015 atom0s [atom0s@live.com]

    A simple addon that exposes some quick usage features for the GrimLua plugin.
    This addon requires GrimLua to be loaded to work!

]]--

---------------------------------------------------------------------------------------------------
-- desc: Main addon information. (These are required for your addon to load!)
---------------------------------------------------------------------------------------------------
_addon.author   = 'atom0s';
_addon.name     = 'GLuaHacks';
_addon.version  = '1.0';

require 'common'

---------------------------------------------------------------------------------------------------
-- func: load
-- desc: The main event called when your addon is loaded.
---------------------------------------------------------------------------------------------------
hook.register_event('load', function() end);

---------------------------------------------------------------------------------------------------
-- func: unload
-- desc: The event called when your addon is unloaded.
---------------------------------------------------------------------------------------------------
hook.register_event('unload', function() end);

---------------------------------------------------------------------------------------------------
-- func: command
-- desc: The event called when a console command has been entered.
---------------------------------------------------------------------------------------------------
hook.register_event('command', function(cmd)
    local args = cmd:GetArgs();
    
    -- User wants to give themselves stat points..
    if (args[1] == '/giveskillpoints') then
        local amount = tonumber(args[2]);
        if (amount == nil) then
            print('Invalid amount for "/giveskillpoints" command!');
            return true;
        end
        local c = string.format('/glua Game.GetLocalPlayer():GiveSkillPoints(%d);', amount);
        HookCore:GetConsole():QueueCommand(c);
        return true;
    end
    
    -- User wants to give themselves levels..
    if (args[1] == '/givelevels') then
        local c = string.format('/glua Game.GetLocalPlayer():GiveLevels(-1)');
        return true;
    end
    
    return false;
end);